/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.debug;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DebugAudioPops
extends JApplet {
    private static final boolean BIG_ENDIAN = false;
    private static final int FRAMES_PER_BUFFER = 64;
    private int requestedBufferSize = 8192;
    private int actualBufferSize;
    private static final long serialVersionUID = 1L;
    SinePlayer player;
    private int frameRate = 44100;
    public int THREAD_PRIORITY_BUMP = 0;
    AudioFormat format;

    void makePlayer() throws LineUnavailableException {
        this.format = new AudioFormat(this.frameRate, 16, 2, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(info)) {
            System.err.println("openOutputLine - not supported." + this.format);
        } else {
            int minSize = info.getMinBufferSize();
            int maxSize = info.getMaxBufferSize();
            System.out.println("min buffer size = " + minSize + ", max buffer size = " + maxSize);
            System.out.println("AudioSystem.NOT_SPECIFIED = -1");
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            if (this.requestedBufferSize > 0) {
                line.open(this.format, this.requestedBufferSize);
            } else {
                line.open(this.format);
            }
            this.actualBufferSize = line.getBufferSize();
            System.out.println("line = " + line + ", buffer size = " + this.actualBufferSize);
            this.player = new SinePlayer(line, this.frameRate);
        }
    }

    void startSine() {
        double freq = 440.0;
        this.player.start();
        this.player.setAmplitude(1.0);
        System.out.println("Start at freq = " + freq);
        this.player.setFrequency(freq);
    }

    @Override
    public void stop() {
        this.player.stop();
        this.removeAll();
    }

    protected int getIntegerParameter(String paramName, int defaultValue) {
        int value = defaultValue;
        String temp = this.getParameter(paramName);
        if (temp != null) {
            try {
                value = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Error in " + paramName + " parameter. Invalid integer = " + temp, e);
            }
        }
        return value;
    }

    @Override
    public void init() {
        try {
            this.frameRate = this.getIntegerParameter("frameRate", this.frameRate);
            this.requestedBufferSize = this.getIntegerParameter("requestedBufferSize", this.requestedBufferSize);
        }
        catch (NullPointerException e) {
            System.err.println("Applet parameters only work when run as an Applet.");
        }
    }

    @Override
    public void start() {
        try {
            this.makePlayer();
            this.startSine();
        }
        catch (LineUnavailableException ex) {
            System.err.println("Caught " + ex);
        }
        this.setLayout(new GridLayout(0, 1));
        this.add(new JLabel("Test Clicks in JavaSound"));
        this.add(new JLabel("java.version = " + System.getProperty("java.version")));
        this.add(new JLabel("java.vendor = " + System.getProperty("java.vendor")));
        this.add(new JLabel("format = " + this.format));
        this.add(new JLabel("requestedBufferSize = " + this.requestedBufferSize));
        this.add(new JLabel("actualBufferSize = " + this.actualBufferSize));
        int calculatedLatency = 1000 * this.actualBufferSize / (this.format.getFrameSize() * this.frameRate);
        this.add(new JLabel("calculatedLatency = " + calculatedLatency + " msec"));
        this.add(new JLabel("Java Vendor is " + System.getProperty("java.vendor")));
        this.add(new JLabel("Java Version is " + System.getProperty("java.version")));
        this.validate();
    }

    public static void main(String[] argv) {
        System.out.println("Debug clicks from JavaSound");
        System.out.println("Version = " + System.getProperty("java.version"));
        DebugAudioPops applet = new DebugAudioPops();
        JFrame frame = new JFrame("Test JavaSound Priority");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DebugAudioPops.this.stop();
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.setSize(500, 200);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", applet);
        frame.setVisible(true);
        applet.init();
        applet.start();
    }

    public class SinePlayer
    implements Runnable {
        Thread thread = null;
        volatile boolean go;
        SourceDataLine line;
        public static final int SAMPLES_PER_FRAME = 2;
        byte[] bytes;
        short[] shorts;
        double phase1;
        double phase2;
        double frequency = 440.0;
        double amplitude = 1.0;
        static final double TWOPI = Math.PI * 2;
        float sampleRate;
        int maxAvailable;
        int hysteresisThreshold;
        boolean reportUnderflowEnabled;
        int averageAvailable;

        public SinePlayer(SourceDataLine line, float sampleRate) {
            this.maxAvailable = DebugAudioPops.this.actualBufferSize / 4;
            this.hysteresisThreshold = this.maxAvailable / 2;
            this.reportUnderflowEnabled = true;
            this.averageAvailable = 0;
            this.line = line;
            this.sampleRate = sampleRate;
            this.bytes = new byte[256];
            this.shorts = new short[128];
        }

        void playShorts() throws LineUnavailableException {
            int bi = 0;
            int i = 0;
            while (i < this.shorts.length) {
                short s16 = this.shorts[i];
                this.bytes[bi++] = (byte)s16;
                this.bytes[bi++] = (byte)(s16 >> 8);
                ++i;
            }
            this.checkUnderflow();
            this.line.write(this.bytes, 0, this.bytes.length);
        }

        private void checkUnderflow() {
            int available = this.line.available();
            if (this.reportUnderflowEnabled && available > this.maxAvailable) {
                this.maxAvailable = available;
                System.out.println("maxAvailable set to " + this.maxAvailable);
                this.reportUnderflowEnabled = false;
                this.hysteresisThreshold = this.maxAvailable / 2;
            }
            this.averageAvailable = (int)(0.9 * (double)this.averageAvailable + 0.1 * (double)available);
        }

        void genStereoSines() {
            double incr1 = 2.0 * this.frequency / (double)this.sampleRate;
            double incr2 = 3.0 * this.frequency / (double)this.sampleRate;
            int isin = 0;
            while (isin < this.shorts.length) {
                this.phase1 += incr1;
                if (this.phase1 > Math.PI * 2) {
                    this.phase1 -= Math.PI * 2;
                }
                this.shorts[isin++] = (short)(32767.0 * this.amplitude * Math.sin(this.phase1));
                this.phase2 += incr2;
                if (this.phase2 > Math.PI * 2) {
                    this.phase2 -= Math.PI * 2;
                }
                this.shorts[isin++] = (short)(32767.0 * this.amplitude * Math.sin(this.phase2));
            }
        }

        double getFrequency() {
            return this.frequency;
        }

        void setFrequency(double freq) {
            this.frequency = freq;
        }

        void setAmplitude(double ampl) {
            this.amplitude = ampl;
        }

        public synchronized void start() {
            this.go = true;
            this.thread = new Thread(this);
            if (DebugAudioPops.this.THREAD_PRIORITY_BUMP > 0) {
                System.out.println("Sine thread old priority = " + this.thread.getPriority());
                this.thread.setPriority(this.thread.getPriority() + DebugAudioPops.this.THREAD_PRIORITY_BUMP);
                System.out.println("Sine thread new priority = " + this.thread.getPriority());
            }
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.go = false;
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.thread = null;
            }
        }

        @Override
        public void run() {
            this.line.start();
            this.prefillOutput();
            while (this.go) {
                this.genStereoSines();
                try {
                    this.playShorts();
                }
                catch (LineUnavailableException ex) {
                    System.err.println("Caught " + ex);
                    break;
                }
            }
            System.out.println("averageAvailable = " + this.averageAvailable);
            this.line.flush();
            this.line.stop();
            this.line.close();
        }

        private void prefillOutput() {
            while (this.line.available() > this.bytes.length) {
                this.line.write(this.bytes, 0, this.bytes.length);
            }
        }
    }
}

