/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.SampleMarker;
import com.jsyn.data.SequentialDataCommon;
import java.util.ArrayList;

public abstract class AudioSample
extends SequentialDataCommon {
    protected int numFrames;
    protected int channelsPerFrame;
    private double frameRate;
    private double pitch;
    private ArrayList<SampleMarker> markers;

    public abstract void allocate(int var1, int var2);

    @Override
    public double getRateScaler(int index, double synthesisRate) {
        return 1.0;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double f) {
        this.frameRate = f;
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public int getChannelsPerFrame() {
        return this.channelsPerFrame;
    }

    public void setChannelsPerFrame(int channelsPerFrame) {
        this.channelsPerFrame = channelsPerFrame;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public double getPitch() {
        return this.pitch;
    }

    public int getMarkerCount() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    public SampleMarker getMarker(int index) {
        if (this.markers == null) {
            return null;
        }
        return this.markers.get(index);
    }

    public void addMarker(SampleMarker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        int idx = this.markers.size();
        int k = 0;
        while (k < this.markers.size()) {
            SampleMarker cue = this.markers.get(k);
            if (cue.position > marker.position) {
                idx = k;
                break;
            }
            ++k;
        }
        this.markers.add(idx, marker);
    }
}

