/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.PortFader;
import com.softsynth.jsyn.view102.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class TestScope
extends Applet {
    SineOscillator sineOsc;
    LineOut lineOut;
    LabelledFader freqFader;
    LabelledFader ampFader;
    SynthScope scope;
    Checkbox expandScope;

    public static void main(String[] args) {
        TestScope applet = new TestScope();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(500, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            this.sineOsc = new SineOscillator();
            this.lineOut = new LineOut();
            this.sineOsc.output.connect(0, this.lineOut.input, 0);
            this.sineOsc.output.connect(0, this.lineOut.input, 1);
            this.sineOsc.amplitude.set(0.0);
            this.lineOut.start();
            this.sineOsc.start();
            this.scope = new SynthScope();
            this.add("Center", this.scope);
            this.scope.createProbe(this.sineOsc.output, "Output", Color.yellow);
            this.scope.finish();
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            this.add("North", faderPanel);
            this.freqFader = new PortFader(this.sineOsc.frequency, "Frequency", 440.0, 0.0, 500.0);
            faderPanel.add(this.freqFader);
            this.ampFader = new PortFader(this.sineOsc.amplitude, "Amplitude", 0.0, 0.0, 1.0);
            faderPanel.add(this.ampFader);
            this.expandScope = new Checkbox("Expand Scope", false);
            faderPanel.add(this.expandScope);
            this.scope.setCaptureRate(2.0);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sineOsc.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.expandScope) {
                if (this.expandScope.getState()) {
                    this.scope.showControls();
                } else {
                    this.scope.hideControls();
                }
                return true;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
        return false;
    }
}

