/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.GridLayout;

public class TJ_GenerationBug
extends Applet {
    SawtoothOscillator myOsc;
    LineOut myOut;
    TriangleOscillator myLFO;
    AddUnit mySum;
    ExponentialLag myLag;
    PanUnit myPanner;

    public static void main(String[] args) {
        TJ_GenerationBug applet1 = new TJ_GenerationBug();
        AppletFrame frame1 = new AppletFrame("Test Java Synthesis", applet1);
        TJ_GenerationBug applet2 = new TJ_GenerationBug();
        AppletFrame frame2 = new AppletFrame("Test Java Synthesis", applet2);
        frame1.resize(600, 300);
        frame1.show();
        frame2.resize(600, 300);
        frame2.show();
        try {
            System.out.println("Start #1");
            applet1.start();
            Thread.sleep(2000L);
            System.out.println("Stop #1");
            applet1.stop();
            Thread.sleep(2000L);
            System.out.println("Start #2");
            applet2.start();
            applet1.killem();
            applet1 = null;
            Runtime.getRuntime().gc();
            Thread.sleep(2000L);
            Runtime.getRuntime().gc();
            Thread.sleep(2000L);
            System.out.println("Ping #2");
            applet2.ping();
            Thread.sleep(1000L);
            System.out.println("Stop #2");
            applet2.stop();
        }
        catch (InterruptedException e) {
            System.err.println(" Caught " + e);
        }
        System.exit(1);
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.myOsc = new SawtoothOscillator();
            this.myLFO = new TriangleOscillator();
            this.mySum = new AddUnit();
            this.myLag = new ExponentialLag();
            System.out.println("Lag = " + this.myLag);
            this.myPanner = new PanUnit();
            this.myOut = new LineOut();
            this.myLag.output.connect(this.mySum.inputB);
            this.myLFO.output.connect(this.mySum.inputA);
            this.mySum.output.connect(this.myOsc.frequency);
            this.myOsc.output.connect(this.myPanner.input);
            this.myPanner.output.connect(0, this.myOut.input, 0);
            this.myPanner.output.connect(1, this.myOut.input, 1);
            this.myLag.input.setSignalType(2);
            this.myLag.current.setSignalType(2);
            this.myLFO.amplitude.setSignalType(2);
            this.add(new PortFader(this.myOsc.amplitude, 0.5, 0.0, 0.999));
            this.add(new PortFader(this.myLFO.frequency, "ModRate", 0.2, 0.0, 20.0));
            this.add(new PortFader(this.myLFO.amplitude, "ModDepth", 400.0, 0.0, 2000.0));
            this.add(new PortFader(this.myLag.input, "CenterFreq", 200.0, 0.0, 2000.0));
            this.add(new PortFader(this.myPanner.pan, 0.0, -1.0, 1.0));
            this.add(new PortFader(this.myLag.halfLife, 0.1, 0.0, 1.0));
            this.myOut.start();
            this.myOsc.start();
            this.mySum.start();
            this.myLag.start();
            this.myPanner.start();
            this.myLFO.start();
        }
        catch (SynthException e) {
            System.out.println("start() caught " + e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void ping() {
        try {
            this.myLag.current.set(2000.0);
        }
        catch (SynthException e) {
            System.err.println("ping() caught " + e);
        }
    }

    public void killem() {
        this.myOsc = null;
        this.myOut = null;
        this.myLFO = null;
        this.mySum = null;
        this.myLag = null;
        this.myPanner = null;
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("stop() caught " + e);
        }
    }
}

